
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1210.C - Message 1210 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1210 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1210.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:47:56   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:45:32   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:30   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 13:47:10   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:53:02   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <string.h>

#include "gentypes.h"
#include "ztypes.h"
#include "zcons.h"
#include "util.h"   

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1210 message from the ZMsgBuf.
//
void Dec1210(tMSGBUF *ZMsgBuf, tMSG1210 *Msg)
{   
   GetShort  (&Msg->SequenceNumber         , ZMsgBuf, 6);    // ND   
   GetUShort (&Msg->DatumID                , ZMsgBuf, 7);    // ND 
   GetULong  (&Msg->SemiMajorAxisInt       , ZMsgBuf, 8);    // meters 
   GetUShort (&Msg->SemiMajorAxisFrac      , ZMsgBuf, 10);   // 1E+04 * meters
   GetUShort (&Msg->InverseFlatteningInt   , ZMsgBuf, 11);   // ND 
   GetULong  (&Msg->InverseFlatteningFrac  , ZMsgBuf, 12);   // 1E+09 * nd
   GetLong   (&Msg->WGS84OffsetdX          , ZMsgBuf, 14);   // 1E+02 * meters 
   GetLong   (&Msg->WGS84OffsetdY          , ZMsgBuf, 16);   // 1E+02 * meters 
   GetLong   (&Msg->WGS84OffsetdZ          , ZMsgBuf, 18);   // 1E+02 * meters
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1210 message in the ZMsgBuf. 
//
void Bld1210(tMSGBUF *ZMsgBuf, tMSG1210 *Msg)
{
   // copy message into buffer
   memcpy(((tSHORT *) ZMsgBuf)+5, Msg, sizeof(*Msg));          

   // build the header in the buffer
   PutShort  (0x81FF                      , ZMsgBuf, 1);    // message preamble
   PutShort  (1210                        , ZMsgBuf, 2);    // message number
   PutShort  (14                          , ZMsgBuf, 3);    // message length 
   PutShort  (ANREQ                       , ZMsgBuf, 4);    // message ack/nack request
   
   PutShort  (Msg->SequenceNumber         , ZMsgBuf, 6);    // ND   
   PutUShort (Msg->DatumID                , ZMsgBuf, 7);    // ND 
   PutULong  (Msg->SemiMajorAxisInt       , ZMsgBuf, 8);    // meters 
   PutUShort (Msg->SemiMajorAxisFrac      , ZMsgBuf, 10);   // 1E+04 * meters
   PutUShort (Msg->InverseFlatteningInt   , ZMsgBuf, 11);   // ND 
   PutULong  (Msg->InverseFlatteningFrac  , ZMsgBuf, 12);   // 1E+09 * nd
   PutLong   (Msg->WGS84OffsetdX          , ZMsgBuf, 14);   // 1E+02 * meters 
   PutLong   (Msg->WGS84OffsetdY          , ZMsgBuf, 16);   // 1E+02 * meters 
   PutLong   (Msg->WGS84OffsetdZ          , ZMsgBuf, 18);   // 1E+02 * meters
}
